import os
from Bio import SeqIO


directory = "."
filenames = os.listdir(directory)
filenames.sort()
n = 0
sequences = set()
for filename in filenames:
    terms = filename.split(".")
    if len(terms) != 3:
        continue
    if terms[1] != "unique":
        continue
    if terms[2] != "fa":
        continue
    library = terms[0]
    timepoint, replicate = library.rsplit("_", 1)
    assert timepoint in ("00_hr", "01_hr", "04_hr", "12_hr", "24_hr", "96_hr")
    assert replicate in "ABCDEFGH"
    print("Reading", filename)
    handle = open(filename)
    records = SeqIO.parse(handle, "fasta")
    for record in records:
        seq = str(record.seq)
        sequences.add(seq)
    handle.close()
    n += 1
    print("%d files read; %d unique sequences" % (n, len(sequences)))

sequences = sorted(sequences)
# Iterating over a set will not return the sequences in the order in which
# they were added to the set; the order will even change between Python runs
# because the hash algorithm changes. Sort the sequences here to guarantee a
# consistent result between runs.

filename = "seqlist.fa"
print("Writing", filename)
handle = open(filename, 'w')
for i, sequence in enumerate(sequences):
    handle.write(">seq_%08d\n" % i)
    handle.write("%s\n" % sequence)

handle.close()
